% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ctrLoadQueryIntoDb}
\alias{ctrLoadQueryIntoDb}
\title{Retrieve or update information on clinical trials from register and store in
database}
\usage{
ctrLoadQueryIntoDb(queryterm = "", register = "EUCTR",
  querytoupdate = 0L, forcetoupdate = FALSE, euctrresults = FALSE,
  annotation.text = "", annotation.mode = "append", details = TRUE,
  parallelretrievals = 10, debug = FALSE, collection = "ctrdata",
  uri = "mongodb://localhost/users",
  password = Sys.getenv("ctrdatamongopassword"), verbose = FALSE)
}
\arguments{
\item{queryterm}{Either a string with the full URL of a search in a register
or the data frame returned by the \link{ctrGetQueryUrlFromBrowser} or the
\link{dbQueryHistory} functions.
The queryterm is recorded in the collection \code{ns} for later use to
update records.}

\item{register}{Vector of abbreviations of registers to query, defaults to
"EUCTR"}

\item{querytoupdate}{Either the word "last" or the number of query (based
on \link{dbQueryHistory}) that should be run to retrieve any trial records
that are new or have been updated since this query was run the last time.
This parameter takes precedence over \code{queryterm}.
For EUCTR, updates are available only for the last seven days;
the query is run again if more time has passed since it was run last.}

\item{forcetoupdate}{If \code{TRUE}, run again the query given in
\code{querytoupdate}, irrespective of when it was run last
(default is \code{FALSE}).}

\item{euctrresults}{If \code{TRUE}, also download available results when
retrieving and loading trials from EUCTR. This slows down this function.
(For CTGOV, all available results are retrieved and loaded from
ctrdata version 0.9.10 onwards.)}

\item{annotation.text}{Text to be including in the records retrieved
with the current query, in the field "annotation".}

\item{annotation.mode}{One of "append" (default), "prepend" or "replace"
for new annotation.text with respect to any existing annotation for
the records retreived with the current query.}

\item{details}{If \code{TRUE} (default), retrieve full protocol-related
information from EUCTR or XML data from CTGOV, depending on the register
selected. This gives all of the available details for the trials.
Alternatively, set to \code{FALSE} to retrieve only summary information
from EUCTR or CSV data from CTGOV. The full EUCTR information includes
separate records for every country in which the trial is opened; use
function \code{dbFindUniqueEuctrRecord} in a subsequent step to limit to
one record from EUCTR per trial}

\item{parallelretrievals}{Number of parallel downloads of information from
the register}

\item{debug}{Printing additional information if set to \code{TRUE}; default
is \code{FALSE}.}

\item{collection}{Name of collection (default is "ctrdata")}

\item{uri}{Default is mongodb://localhost/users/.
Address of database in mongodb server, based on mongo connection string
format: mongodb://[username@]host1[:port1][,...hostN[:portN]]]/database/
Do NOT include password, this will only be used from the parameter.
See \url{http://docs.mongodb.org/manual/reference/connection-string/}}

\item{password}{In case access requires credentials.
Note this defaults to the environment variable "ctrdatamongopassword".
(by means of \code{Sys.getenv("ctrdatamongopassword")}), to
support scripting without revealing secrets.}

\item{verbose}{Print information.}
}
\value{
Number of trials imported or updated in the database
}
\description{
Note that upsert is used to store data in database, which means that records
may accumulate in a data base from different queries. If you want to insert
into an empty database, include a mongo connection object to an empty database.
}
\examples{
# Retrieve protocol-related information on a single trial identified by EudraCT number
\dontrun{
ctrLoadQueryIntoDb (queryterm = "2013-001291-38")
}

# For use with EudraCT: define paediatric population and cancer terms
\dontrun{
queryEuDefPaedPopulation  <- "age=under-18"
queryEuDef01paedOncTrials <- "cancer leukaem leukem sarcoma tumour tumor blastom gliom lymphom
malign hodgkin ewing rhabdo teratom tumeur leucemi"
queryEuDef01paedOncTrials <- gsub (" ", "\%20OR\%20", queryEuDef01paedOncTrials)
queryEuDef01paedOncTrials <- paste (queryEuDef01paedOncTrials, queryEuDefPaedPopulation, sep="&")
ctrLoadQueryIntoDb (queryterm = queryEuDef01paedOncTrials, parallelretrivals = 5)
}

# Retrieve protocol-related information on ongoing interventional cancer trials in children
\dontrun{
ctrLoadQueryIntoDb (queryterm = "cancer&recr=Open&type=Intr&age=0", register = "CTGOV")
ctrLoadQueryIntoDb (queryterm = "NCT02239861", register = "CTGOV")
}

}
