% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbFindIdsUniqueTrials.R
\name{dbFindIdsUniqueTrials}
\alias{dbFindIdsUniqueTrials}
\title{Get identifiers of deduplicated trial records}
\usage{
dbFindIdsUniqueTrials(
  preferregister = c("CTGOV2", "EUCTR", "CTGOV", "ISRCTN", "CTIS"),
  prefermemberstate = "BE",
  include3rdcountrytrials = TRUE,
  con,
  verbose = FALSE
)
}
\arguments{
\item{preferregister}{A vector of the order of preference for
registers from which to generate unique _id's, default
\code{c("CTGOV2", "EUCTR", "CTGOV", "ISRCTN", "CTIS")}}

\item{prefermemberstate}{Code of single EU Member State for which records
should returned. If not available, a record for BE or lacking this, any
random Member State's record for the trial will be returned.
For a list of codes of EU  Member States, please see vector
\code{countriesEUCTR}. Specifying "3RD" will return the Third Country
record of trials, where available.}

\item{include3rdcountrytrials}{A logical value if trials should be retained
that are conducted exclusively in third countries, that is, outside
the European Union. Ignored if \code{prefermemberstate} is set to "3RD".}

\item{con}{A database connection object, created with
\code{nodbi}. See section `1 - Database connection` in
\link{ctrdata}.}

\item{verbose}{If \code{TRUE}, prints out the fields of registers used to
find corresponding trial records}
}
\value{
A named vector with strings of keys (field "_id") of
records in the collection that represent unique trials, where
names correspond to the register of the record.
}
\description{
Records for a clinical trial can be loaded from more than one
register into a collection. This function returns deduplicated
identifiers for all trials in the collection, respecting the
register(s) preferred by the user. All registers are recording
identifiers also from other registers, which are used by this
function to provide a vector of identifiers of deduplicated trials.
}
\details{
Note that the content of records may differ between registers
(and, for "EUCTR", between records for different Member States).
Such differences are not considered by this function.

Note that the trial concept \link{f.isUniqueTrial} (which uses this
function) can be calculated at the time of creating a data frame with
\link{dbGetFieldsIntoDf}, which often may be the preferred approach.
}
\examples{

dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials",
  flags = RSQLite::SQLITE_RO)

dbFindIdsUniqueTrials(con = dbc)[1:10]

# alternative as of ctrdata version 1.21.0,
# using defaults of dbFindIdsUniqueTrials()
df <- dbGetFieldsIntoDf(
  fields = "keyword",
  calculate = "f.isUniqueTrial",
  con = dbc)

# using base R
df[df[[".isUniqueTrial"]], ]

\dontrun{
library(dplyr)
df \%>\% filter(.isUniqueTrial)
}

}
