% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanTIpredMarginal.R
\name{ctStanTIpredMarginal}
\alias{ctStanTIpredMarginal}
\title{Plot marginal relationships between covariates and parameters for a ctStanFit object.}
\usage{
ctStanTIpredMarginal(fit, tipred, pars, plot = TRUE)
}
\arguments{
\item{fit}{ctStanFit object.}

\item{tipred}{character vector representing which tipreds to use.}

\item{pars}{Subject level matrices from the ctStanFit output -- e.g, 'DRIFT' or 'DIFFUSION'.}

\item{plot}{Logical, whether to plot.}
}
\value{
If \code{plot=TRUE}, nothing, otherwise an array that can be used with ctPlotArray.
}
\description{
Plot marginal relationships between covariates and parameters for a ctStanFit object.
}
\examples{
\donttest{
if (!exists("ctstantestfit")) example(ctstantestfit)
ctStanTIpredMarginal(ctstantestfit,pars=c('DRIFT','CINT'),tipred=c('TI2','TI3'))
}
}
