% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ifsct.R
\encoding{UTF-8}
\name{plot_ifsct}
\alias{plot_ifsct}
\title{Constructs the IFS circle transformation of a
categorical time series}
\usage{
plot_ifsct(series, alpha, beta, title = "IFS circle transformation", ...)
}
\arguments{
\item{series}{An object of type \code{tsibble} (see R package \code{tsibble}), whose column named Value
contains the values of the corresponding CTS. This column must be of class \code{factor} and its levels
must be determined by the range of the CTS.}

\item{alpha}{Parameter alpha in the circle transformation.}

\item{beta}{Parameter beta in the circle transformation.}

\item{title}{The title of the graph.}

\item{...}{Additional parameters for the function.}
}
\value{
The IFS circle transformation.
}
\description{
\code{plot_ifsct} constructs the IFS circle transformation of
a categorical time series.
}
\details{
Constructs the IFS circle transformation for a given CTS, which is
useful to identify cycles of arbitrary length.
}
\examples{
sequence_1 <- GeneticSequences[which(GeneticSequences$Series==1),]
ct <- plot_ifsct(sequence_1, alpha = 0.1, beta = 0.1) # Constructing the IFS circle transformation
# for the first CTS in dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2008visual}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
