% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hazard-APIs-batch.R
\name{get_human_hazard_by_dtxsid_batch}
\alias{get_human_hazard_by_dtxsid_batch}
\title{Get human hazard data by DTXSID batch}
\usage{
get_human_hazard_by_dtxsid_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = hazard_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{A list of chemical identifier DTXSIDs.}

\item{API_key}{The user-specific API key.}

\item{rate_limit}{Number of seconds to wait between each request}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
A data.table containing chemical human hazard data.
}
\description{
Get human hazard data by DTXSID batch
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull human hazard data for multiples chemicals
dtxsid <- c('DTXSID7020182', 'DTXSID2021315')
dtxsid_human_hazard <- get_human_hazard_by_dtxsid_batch(DTXSID = dtxsid)
\dontshow{\}) # examplesIf}
}
