% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_info.R
\name{get_codon_table}
\alias{get_codon_table}
\title{get codon table by NCBI gene code ID}
\usage{
get_codon_table(gcid = "1")
}
\arguments{
\item{gcid}{a string of genetic code id. run `show_codon_tables()` to see available codon tables.}
}
\value{
a `data.table` with four columns: aa_code, amino_acid, codon, and subfam.
}
\description{
\code{get_codon_table} creates a codon table based on the given id of genetic code in NCBI.
}
\examples{
# Standard genetic code
get_codon_table()

# Vertebrate Mitochondrial genetic code
get_codon_table(gcid = '2')
}
