% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cure_plot.R
\name{cure_plot}
\alias{cure_plot}
\title{CURE Plot}
\usage{
cure_plot(x, covariate = NULL, n_resamples = 0)
}
\arguments{
\item{x}{Either a data frame produced with
\code{\link{calculate_cure_dataframe}}, in that case, the first column is
used to produce CURE plot; or regression model for count data (e.g.,
Poisson) adjusted with \code{\link[stats]{glm}} or \code{\link[mgcv]{gam}}.}

\item{covariate}{Required when \code{x} is model fit.}

\item{n_resamples}{Number of resamples to overlay on CURE plot. Zero is the
default.}
}
\value{
A CURE plot generated with \pkg{ggplot2}.
}
\description{
CURE Plot
}
\examples{
## basic example code

set.seed(2000)

## Define parameters
beta <- c(-1, 0.3, 3)

## Simulate independent variables
n <- 900
AADT <- c(runif(n, min = 2000, max = 150000))
nlanes <- sample(x = c(2, 3, 4), size = n, replace = TRUE)
LNAADT <- log(AADT)

## Simulate dependent variable
theta <- exp(beta[1] + beta[2] * LNAADT + beta[3] * nlanes)
y <- rpois(n, theta)

## Fit model
mod <- glm(y ~ LNAADT + nlanes, family = poisson)

## Calculate residuals
res <- residuals(mod, type = "working")

## Calculate CURE plot data
cure_df <- calculate_cure_dataframe(AADT, res)

head(cure_df)

## Providing CURE data frame
cure_plot(cure_df)

## Providing glm object
cure_plot(mod, "LNAADT")

## Providing glm object adding resamples cumulative residuals
cure_plot(mod, "LNAADT", n_resamples = 3)
}
