% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.curesurv.R
\name{summary.curesurv}
\alias{summary.curesurv}
\title{summary for a curesurv cure model}
\usage{
\method{summary}{curesurv}(
  object,
  digits = max(1L, getOption("digits") - 3L),
  signif.stars = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class "curesurv".}

\item{digits}{minimum number of significant digits to be used for
most numbers.}

\item{signif.stars}{logical; if TRUE, P-values are additionally encoded
visually as "significance stars" in order to help scanning of long
coefficient tables.}

\item{...}{additional options}
}
\value{
an object of class "curesurv" representing the fit. See \code{curesurv} for details.
}
\description{
summary an object of class "curesurv"
}
\examples{

library("curesurv")
library("survival")



# overall survival setting
# Mixture cure model with Weibull function for the uncured patients survival:
# no covariate



fit_ml0 <- curesurv(Surv(time_obs, event) ~ 1 | 1,
             model = "mixture", dist = "weib",
             data = testiscancer,
             method_opt = "L-BFGS-B")


 summary(fit_ml0)

}
\references{
Boussari O, Bordes L, Romain G, Colonna M, Bossard N,
Remontet L, Jooste V. Modeling excess hazard with time-to-cure
as a parameter. Biometrics. 2020 Aug 31.
doi: 10.1111/biom.13361. Epub ahead of print.
PMID: 32869288.
(\href{https://pubmed.ncbi.nlm.nih.gov/32869288/}{pubmed})

Phillips N, Coldman A, McBride ML. Estimating cancer prevalence using
mixture models for cancer survival. Stat Med. 2002 May 15;21(9):1257-70.
doi: 10.1002/sim.1101. PMID: 12111877.
(\href{https://pubmed.ncbi.nlm.nih.gov/12111877/}{pubmed})

De Angelis R, Capocaccia R, Hakulinen T, Soderman B, Verdecchia A. Mixture
models for cancer survival analysis: application to population-based data
with covariates. Stat Med. 1999 Feb 28;18(4):441-54.
doi: 10.1002/(sici)1097-0258(19990228)18:4<441::aid-sim23>3.0.co;2-m.
PMID: 10070685. (\href{https://pubmed.ncbi.nlm.nih.gov/10070685/}{pubmed})
}
\seealso{
\code{\link[=predict.curesurv]{predict.curesurv()}}, \code{\link[=curesurv]{curesurv()}}, \code{browseVignettes("curesurv")}
}
\author{
Juste Goungounga, Judith Breaud, Eugenie Blandin, Olayide Boussari, Valerie Jooste
}
\keyword{summary.curesurv}
