% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_x.R
\name{plot_x}
\alias{plot_x}
\title{Plot the distribution of the independent variable per class from a cutpointr object}
\usage{
plot_x(x, display_cutpoint = TRUE, ...)
}
\arguments{
\item{x}{A cutpointr object.}

\item{display_cutpoint}{(logical) Whether or not to display the optimal
cutpoint as a vertical line.}

\item{...}{Additional arguments (unused).}
}
\description{
Given a \code{cutpointr} object this function plots the distribution(s) of the
independent variable(s) and the respective cutpoints per class.
}
\examples{
opt_cut <- cutpointr(suicide, dsi, suicide)
plot_x(opt_cut)

## With subgroup
opt_cut_2groups <- cutpointr(suicide, dsi, suicide, gender)
plot_x(opt_cut_2groups)
}
\seealso{
Other cutpointr plotting functions: 
\code{\link{plot.cutpointr}()},
\code{\link{plot_cut_boot}()},
\code{\link{plot_cutpointr}()},
\code{\link{plot_metric_boot}()},
\code{\link{plot_metric}()},
\code{\link{plot_precision_recall}()},
\code{\link{plot_roc}()},
\code{\link{plot_sensitivity_specificity}()}
}
\concept{cutpointr plotting functions}
