% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.cvCovEst}
\alias{plot.cvCovEst}
\title{Generic Plot Method for cvCovest}
\usage{
\method{plot}{cvCovEst}(
  x,
  dat_orig,
  estimator = NULL,
  plot_type = c("summary"),
  stat = c("min"),
  k = NULL,
  leading = TRUE,
  abs_v = TRUE,
  switch_vars = FALSE,
  min_max = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class, \code{"cvCovEst"}.  Specifically, this is the
standard output of the function \code{cvCovEst}.}

\item{dat_orig}{The \code{numeric data.frame}, \code{matrix}, or similar
object originally passed to \code{cvCovEst}.}

\item{estimator}{A \code{character} vector specifying one or more classes of
estimators to compare.  If \code{NULL}, the class of estimator associated
with optimal \code{cvCovEst} selection is used.}

\item{plot_type}{A \code{character} vector specifying one of four choices of
diagnostic plots.  Default is \code{"summary"}.  See Details for more about
each plotting choice.}

\item{stat}{A \code{character} vector of one or more summary statistics to
use when comparing estimators.  Default is \code{"min"} for minimum
cross-validated risk.  See Details for more options.}

\item{k}{A \code{integer} indicating the number of leading/trailing
eigenvalues to plot. If \code{NULL}, will default to the number of columns
in \code{dat_orig}.}

\item{leading}{A \code{logical} indicating if the leading eigenvalues should
be used.  Default is \code{TRUE}.  If \code{FALSE}, the trailing eigenvalues
are used instead.}

\item{abs_v}{A \code{logical} determining if the absolute value of the matrix
entries should be used for plotting the matrix heat map.  Default is
\code{TRUE}.}

\item{switch_vars}{A \code{logical}. If \code{TRUE}, the hyperparameters used
for the x-axis and factor variables are switched in the plot of the
cross-validated risk.  Only applies to estimators with more than one
hyperparameter. Default is \code{FALSE}.}

\item{min_max}{A \code{logical}.  If \code{TRUE}, only the minimum and
maximum values of the factor hyperparameter will be used.  Only applies to
estimators with more than one hyperparameter. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to the plot method.  These are not
explicitly used and should be ignored by the user.}
}
\value{
A plot object
}
\description{
The \code{plot} method is a generic method for plotting objects
of class, \code{"cvCovEst"}.  The method is designed as a tool for diagnostic
and exploratory analysis purposes when selecting a covariance matrix
estimator using \code{cvCovEst}.
}
\details{
This plot method is designed to aide users in understanding the
estimation procedure carried out in \code{\link{cvCovEst}()}. There are
currently four different values for \code{plot_type} that can be called:
\itemize{
\item \code{"eigen"} - Plots the eigenvalues associated with the
specified \code{estimator} and \code{stat} arguments in decreasing
order.
\item \code{"risk"} - Plots the cross-validated risk of the specified
\code{estimator} as a function of the hyperparameter values passed to
\code{\link{cvCovEst}()}.  This type of plot is only compatible with
estimators which take hyperparameters as arguments.
\item \code{"heatmap"} - Plots a covariance heat map associated with the
specified \code{estimator} and \code{stat} arguments.  Multiple
estimators and performance stats may be specified to produce grids of
heat maps.
\item \code{"summary"} - Specifying this plot type will run all of the
above plots for the best performing estimator selected by
\code{\link{cvCovEst}()}.  These plots are then combined into a single
panel along with a table containing the best performing estimator
within each class.  If the optimal estimator selected by
\code{\link{cvCovEst}()} does not have hyperparameters, then the risk
plot is replaced with a table displaying the minimum, first quartile,
median, third quartile, and maximum of the cross-validated risk
associated with each class of estimator.
}

The \code{stat} argument accepts five values.  They each correspond to a
summary statistic of the cross-validated risk distribution within a class
of estimator.  Possible values are:
\itemize{
\item \code{"min"} - minimum
\item \code{"Q1"} - first quartile
\item \code{"median"} - median
\item \code{"Q3"} - third quartile
\item \code{"max"} - maximum
}
}
\examples{
cv_dat <- cvCovEst(
  dat = mtcars,
  estimators = c(
    thresholdingEst, sampleCovEst
  ),
  estimator_params = list(
    thresholdingEst = list(gamma = seq(0.1, 0.9, 0.1))
  ),
  center = TRUE,
  scale = TRUE
)

plot(x = cv_dat, dat_orig = mtcars)
}
