% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calibrate}
\alias{calibrate}
\alias{calibrate,EffectScenario-method}
\alias{calibrate,CalibrationSet-method}
\alias{calibrate,list-method}
\title{Fit model parameters to experimental data}
\usage{
calibrate(x, ...)

\S4method{calibrate}{EffectScenario}(
  x,
  par,
  data,
  endpoint = deprecated(),
  output,
  by,
  metric_fun = deprecated(),
  err_fun,
  as_tibble = deprecated(),
  catch_errors = deprecated(),
  verbose = TRUE,
  ...
)

\S4method{calibrate}{CalibrationSet}(x, par, output, err_fun, verbose = TRUE, ...)

\S4method{calibrate}{list}(
  x,
  par,
  endpoint = deprecated(),
  output,
  metric_fun = deprecated(),
  metric_total = deprecated(),
  err_fun,
  as_tibble = deprecated(),
  catch_errors = deprecated(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{either a single \link{scenario} or a list of \link{caliset} objects to be fitted}

\item{...}{additional parameters passed on to \code{\link[stats:optim]{stats::optim()}} and \code{\link[=simulate]{simulate()}}}

\item{par}{named numeric vector with parameters to fit and their start values}

\item{data}{\code{data.frame} with two or more columns with experimental data,
1st column must contain time points, the following columns may values
which the scenario is fitted to.}

\item{endpoint}{\emph{deprecated} \code{character}, please use \code{output} instead}

\item{output}{\code{character}, name of a single output column of \code{\link[=simulate]{simulate()}} to
optimize on}

\item{by}{optional \code{character}, groups and splits the experimental data
into multiple distinct trials and datasets before fitting}

\item{metric_fun}{\emph{deprecated}, please use \code{err_fun} instead}

\item{err_fun}{vectorized error function to calculate an error term that is
minimized during optimization, must accept exactly four vectorized
arguments, defaults to sum of squared errors}

\item{as_tibble}{\emph{deprecated}, result can no longer be returned as a tibble}

\item{catch_errors}{\emph{deprecated}, simulation errors are always caught}

\item{verbose}{\code{logical}, if \code{TRUE} then debug outputs are displayed during
optimization}

\item{metric_total}{\emph{deprecated}}
}
\value{
A list of fitted parameters (as produced by \code{\link[stats:optim]{stats::optim()}})
is returned.
}
\description{
The function \code{calibrate()} performs the calibration (fitting) of model
parameters to observed data. The data can originate from one or more experiments or
trials. Experimental conditions, such as model parameters and exposure
level, can differ between trials; fitting can be performed on all datasets
at the same time.
}
\details{
Fitting of model parameters can be performed in two ways:
\enumerate{
\item A single \link{scenario} is fitted to a single dataset.
The dataset must represent a time-series of an output variable of the
model, e.g. observed biomass over time (effect data). The dataset can represent
results of one or more experimental replicates under identical conditions.
\item One or more datasets of observed data are fitted each to a scenario which
describes the experimental conditions during observation, such as exposure
level and environmental properties. Each combination of dataset and scenario
is represented by a \link[=caliset]{calibration set}. During fitting,
all \emph{calibration sets} are evaluated and a total error term is calculated
over all observed and predicted values.
}
\subsection{Observed data}{

Experimental, or effect, data must be supplied as a \code{data.frame} in long format
with at least two columns: the first column contains \code{numeric} timestamps and
the remaining columns must contain the observed quantity. The dataset must
contain a column that which matches with the contents of parameter \code{output}.

As an example, the simulation result of \link{Lemna_Schmitt} model contains the
output column \emph{biomass} (\code{BM}), amongst others. To fit model parameters of said
\emph{Lemna_Schmitt} scenario based on observed biomass, the observed data must
contain a column named \code{BM} which represents the observed biomass.
A minimal observed dataset could look like this:

\if{html}{\out{<div class="sourceCode">}}\preformatted{observed <- data.frame(time=c(0,  7, 14, 21),
                       BM=c( 12, 23, 37, 56))
}\if{html}{\out{</div>}}
}

\subsection{Error function}{

By default, the total sum of squared errors is used as the target
function which is minimized during fitting. A custom error function can be
supplied by the user: The function must accept four vectorized
arguments and return a numeric of length one, i.e. the total error value
which gets \emph{minimized} by \code{calibrate()}.

Example of a custom error function which returns the sum of absolute errors:

\if{html}{\out{<div class="sourceCode">}}\preformatted{my_absolute_error <- function(observed, predicted, weights, tags) \{
  sum(abs(observed - predicted))
\}
}\if{html}{\out{</div>}}

The arguments to the error function will contain all observed and predicted
values, as well as any weights and tags that were defined by the \emph{calibration sets}.
As tags are optional, the fourth argument may be a list containing \code{NULL} values.
The fourth argument can be used to pass additional information to the error
function: For example, the tag may identify the study from where the data
originates from and the error function could group and evaluate the data
accordingly.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{calibrate(EffectScenario)}: Fit single scenario using a dataset

\item \code{calibrate(CalibrationSet)}: Fit using a \link{CalibrationSet}

\item \code{calibrate(list)}: Fit using a list of \link{caliset} objects

}}
\examples{
library(dplyr)

# Get observed biomass during control experiment by Schmitt et al. (2013)
observed <- Schmitt2013 \%>\%
  filter(ID == "T0") \%>\%
  select(t, BM=obs)

# Create a scenario that represents conditions during experiment
scenario <- metsulfuron \%>\%
  set_param(c(k_phot_fix=TRUE, k_resp=0, Emax=1)) \%>\%
  set_init(c(BM=12)) \%>\%
  set_noexposure()

# Fit parameter 'k_phot_max' to observed biomass growth from experiment
calibrate(
  scenario,
  par=c(k_phot_max=1),
  data=observed,
  output="BM",
  method="Brent", # Brent is recommended for one-dimensional optimization
  lower=0,        # lower parameter boundary
  upper=0.5       # upper parameter boundary
) -> fit
fit$par

}
