% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-debtox.R, R/model-deb_daphnia.R
\name{DEBtox}
\alias{DEBtox}
\alias{DEBtox2019}
\alias{DebTox-class}
\alias{DEB_Daphnia}
\alias{DebDaphnia-class}
\title{DEBtox model}
\usage{
DEBtox()

DEB_Daphnia()
}
\value{
an S4 object of type \linkS4class{DebTox}
}
\description{
Creates a  \emph{DEBtox} scenario as described by Jager (2020). It
represents a simplified \emph{DEBtox} model based on \emph{DEBkiss}. In the \emph{BYOM}
application [\href{https://www.debtox.info/byom.html}{link}], this model is
referred to as \emph{DEBtox 2019}, version 4.7.
It supports an optional feature of the \emph{ERA special} model variant, which
can consider a reference \emph{Lm} parameter to compare results of multiple
datasets.
}
\details{
\subsection{State variables}{

The following list describes the names and units of the
model's state variables:
\itemize{
\item \code{D}, scaled damage ([C])
\item \code{L}, body length (mm)
\item \code{R}, cumulative reproduction (-)
\item \code{S}, survival probability (-)
}

State variables \code{D}, \code{L}, and \code{R} are initialized with zero. Variable \code{S}
is initialized with one (\code{1.0}). See \code{\link[=set_init]{set_init()}} on how to set
the initial state manually.
}

\subsection{Parameters}{

The following parameters are required:
\itemize{
\item General
\itemize{
\item \code{L0}, body length at start (mm)
\item \code{Lp}, body length at puberty (mm)
\item \code{Lm}, maximum body length (mm)
\item \code{rB}, von Bertalanffy growth rate constant (1/d)
\item \code{Rm}, maximum reproduction rate (#/d)
\item \code{f}, scaled functional response (-)
\item \code{hb}, background hazard rate (d-1)
\item \code{a}, Weibull background hazard coefficient (-). Set to \code{1} to disable.
}
\item Extra parameters
\itemize{
\item \code{Lf}, body length at half-saturation feeding (mm)
\item \code{Lj}, body length at which acceleration stops (mm)
\item \code{Tlag}, lag time for start development (d)
}
\item TK/TD parameters
\itemize{
\item \code{kd}, dominant rate constant (d-1)
\item \code{zb}, effect threshold energy budget ([C])
\item \code{bb}, effect strength energy-budget effects (1/[C])
\item \code{zs}, effect threshold survival ([C])
\item \code{bs}, effect strength survival (1/([C] d))
}
\item Other parameters (formerly globals in \emph{BYOM})
\itemize{
\item \code{FBV}, dry weight egg as fraction of structural body weight (-)
\item \code{KRV}, part. coeff. repro buffer and structure (kg/kg) (for losses with reproduction)
\item \code{kap}, approximation for kappa (for starvation response)
\item \code{yP}, product of yVA and yAV (for starvation response)
\item \code{Lm_ref}, optional reference max length for scaling rate constants (mm).
Set to zero to disable the reference length. Disabled by default.
\item \code{len}, a switch to control body length dynamics: \code{1} organism can shrink,
\code{2} organism cannot shrink. Default value is \code{1}.
\item \code{Tbp}, optional brood-pouch delay (d). Set to \code{NA} or zero to disable.
Default value is \code{0}.
\item \code{MoA}, mode of action switches (-). Default value is \code{0}.
\item \code{FB}, feedback on damage dynamics switches (-). Default value is \code{0}.
}
}

A reference \code{Lm_ref} is needed to properly compare different data sets,
or when calibrating on more than one data set. If \code{Lm} differs, one would not
want to have different rate constants at the same length.
\subsection{Mode of Action}{

Any combination of the following mode of actions (\emph{MoA}) can be considered by
the model:
\itemize{
\item \code{MoA = 1}: assimilation/feeding
\item \code{MoA = 2}: costs for maintenance
\item \code{MoA = 4}: costs for growth and reproduction
\item \code{MoA = 8}: costs for reproduction
\item \code{MoA = 16}: hazard for reproduction
}

To activate more than one mode of action, simply add up the corresponding
codes and set parameter \code{MoA} to the desired value. To disable all mode of
actions, set parameter \code{MoA} to zero. See also \code{\link[=set_moa]{set_moa()}}.

As an example, to consider effects on feeding and maintenance, set the
mode of action to three (\code{3}):

\code{DEBtox() \%>\% set_param(c(MoA=3))}
}

\subsection{Feedbacks}{

Any combination of the following damage feedbacks can be considered by
the model:
\itemize{
\item \code{1}: surf:vol scaling uptake rate
\item \code{2}: surf:vol scaling elimination rate
\item \code{4}: growth dilution
\item \code{8}: losses with reproduction
}

To activate more than one feedback, simply add up the corresponding
codes. To disable all feedbacks, set the parameter to zero.
}

}

\subsection{Effects}{

The state variables \emph{L} (body length), \emph{R} (cumulative reproduction), and
\emph{S} (survival probability) are set as effect endpoints by default. All state
variables are available as potential endpoints. The list of considered
endpoints can be modified by using \code{\link[=set_endpoints]{set_endpoints()}}.

To calculate effects, each \emph{DEBtox} scenario is simulated twice: One simulation
which considers exposure to a toxicant and one simulation without exposure, i.e.
a control. See also \code{\link[=effect]{effect()}}.
}

\subsection{Simulation output}{

The following intermediary model variables can be added to the model
output on demand. Simply set the optional parameter \code{nout} to the
required output level and pass it to \code{\link[=simulate]{simulate()}}.
\itemize{
\item \code{nout} >= 1: \code{f}, actual scaled response
\item \code{nout} >= 2: \code{fR}, actual f considering starvation
\item \code{nout} >= 3: \code{kd}, actual kd
\item \code{nout} >= 4: \code{s}, stress level
\item \code{nout} >= 5: \code{h}, hazard rate
\item \code{nout} >= 6: \code{sA}, stress factor on assimilation/feeding
\item \code{nout} >= 7: \code{sM}, stress factor on maintenance
\item \code{nout} >= 8: \code{sG}, stress factor on growth costs
\item \code{nout} >= 9: \code{sR}, stress factor on reproduction costs
\item \code{nout} >= 10: \code{sH}, stress factor on hazard to reproduction
\item \code{nout} >= 11: \code{xu}, damage feedback factor for surf:vol scaling uptake rate
\item \code{nout} >= 12: \code{xe}, damage feedback factor for surf:vol scaling elimination rate
\item \code{nout} >= 13: \code{xG}, damage feedback factor for growth dilution
\item \code{nout} >= 14: \code{xR}, damage feedback factor for losses with repro
}
}

\subsection{Solver settings}{

The arguments to ODE solver \code{\link[deSolve:ode]{deSolve::ode()}} control how model equations
are numerically integrated. The settings influence stability of the numerical
integration scheme as well as numerical precision of model outputs. Generally, the
default settings as defined by \emph{deSolve} are used, but all \emph{deSolve} settings
can be modified in \emph{cvasi} workflows by the user, if needed. Please refer
to e.g. \code{\link[=simulate]{simulate()}} on how to pass arguments to \emph{deSolve} in \emph{cvasi}
workflows.

Some default settings of \emph{deSolve} were adapted for this model by expert
judgement to enable precise, but also computationally efficient, simulations
for most model parameters. These settings can be modified by the user,
if needed:
\itemize{
\item \code{method = 'ode45'}\if{html}{\out{<br>}}
Selects the Dormand-Prince 4(5) method of the Runge-Kutta family, see
\code{\link[deSolve:rkMethod]{deSolve::rkMethod()}} for details.
}
}

\subsection{Model history and changes}{
\itemize{
\item cvasi v1.0.0
\itemize{
\item The \code{DEB_Daphnia()} model implemented BYOM's \emph{DEBtox 2019}
model version 4.5
}
\item cvasi v1.2.0
\itemize{
\item The model equations were updated to conform with BYOM's \emph{DEBtox 2019}
version 4.7. This introduced a new model parameter \code{a}, the Weibull
background hazard coefficient, and limited the maximum hazard rate to
99\% per hour.
\item The scenario constructor was renamed to \code{DEBtox()}.
\item Additional intermediary model variables available as optional simulation
output
}
}
}
}
\section{Functions}{
\itemize{
\item \code{DEB_Daphnia()}: Deprecated model variant of \code{DEBtox()}

}}
\references{
Jager T, 2020: Revisiting simplified DEBtox models for analysing
ecotoxicity data. Ecol Model 416. \doi{10.1016/j.ecolmodel.2019.108904}

Romoli et al., 2024: Environmental risk assessment with energy budget
models: a comparison between two models of different complexity.
Environ Toxicol Chem 43(2):440-449. \doi{10.1002/etc.5795}
}
\seealso{
Other DEB models: 
\code{\link{DEB-models}},
\code{\link{DEB_abj}()}
}
\concept{DEB models}
