% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.r
\name{plot_epx}
\alias{plot_epx}
\title{Plot EPx values}
\usage{
plot_epx(
  EPx_ts,
  exposure_ts,
  draw = TRUE,
  time_col = "time",
  conc_col = "conc",
  epx_x_title = "Start time",
  conc_y_title = "Exposure conc."
)
}
\arguments{
\item{EPx_ts}{the result of \code{epx_mtw}, ie. a tibble with window.start,
window.end, endpoint, level and EPx}

\item{exposure_ts}{an exposure time series with columns for time 't' and
concentration 'conc'}

\item{draw}{Should the whole plot be drawn? If FALSE the exposure plot and
the EPx plot are returned as a list for later modification}

\item{time_col}{the name of the time column in the exposure dataset}

\item{conc_col}{the name of the concentration column in the exposure dataset}

\item{epx_x_title}{title of the x-axis of the epx panel}

\item{conc_y_title}{title of the y-axis of the concentration panel}
}
\value{
a grid of ggplots
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
ti <- 0:21
expo <- abs(0.01*ti + rnorm(length(ti), 0, 0.05))
exposure <- data.frame(time = ti, conc = expo)
metsulfuron_epx_mtw <- metsulfuron \%>\%
set_exposure(exposure) \%>\%
epx_mtw(level = 10, factor_cutoff = 1000)
metsulfuron_epx_mtw
plot_epx(EPx_ts = metsulfuron_epx_mtw,
exposure_ts = exposure, conc_y_title = "env. concentration [µg/L]")
}
