% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_window.R
\name{set_window}
\alias{set_window}
\alias{set_nowindow}
\title{Set window length}
\usage{
set_window(x, length, interval)

set_nowindow(x)
}
\arguments{
\item{x}{vector of \code{EffectScenario} objects}

\item{length}{\code{numeric}, length of exposure window to consider for effect
calculation, set \code{length=-1} to disable moving windows}

\item{interval}{\code{numeric}, interval between considered exposure windows}
}
\value{
modified \code{EffectScenario} objects
}
\description{
Exposure windows are defined as a period of time at the scale of the exposure series.
As an example: if an exposure series has an hourly time step, a window length
of \code{24} will consider the exposure within 24 hours intervals for effect
calculation. The same applies for the window interval, i.e. the period between
considered exposure windows. Set \code{length=-1} to disable moving windows.
}
\section{Functions}{
\itemize{
\item \code{set_nowindow()}: Disable moving windows

}}
\examples{
# Calculate the maximum effect for all windows of 10 days length
metsulfuron \%>\%
  set_window(length=10, interval=1) \%>\%
  effect()

# Disable moving exposure windows
metsulfuron \%>\%
  set_nowindow() \%>\%
  effect()
}
