% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_system_level}
\alias{cvd_area_system_level}
\title{List system levels per time period}
\usage{
cvd_area_system_level(time_period_id = 1)
}
\arguments{
\item{time_period_id}{integer - the time period to return data for (compulsory)}
}
\value{
tibble of system levels available for the time period
}
\description{
Returns all available system levels for a specified time period.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2FsystemLevel}{System levels per time period}
}
\examples{
# list system levels for time period 4
cvd_area_system_level(time_period_id = 4) |>
  dplyr::select(SystemLevelID, SystemLevelName)
}
\seealso{
\code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_search]{cvd_area_search()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}
}
