% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_pathway_group}
\alias{cvd_indicator_pathway_group}
\title{Pathway groups}
\usage{
cvd_indicator_pathway_group(pathway_group_id = 10)
}
\arguments{
\item{pathway_group_id}{integer - the pathway to return data for (compulsory)}
}
\value{
Tibble of indicators grouped by pathway groups
}
\description{
Pathway groups are sub-groupings of Priority Groups, visible in the Regional
& ICS Insights page. This endpoint returns a single pathway group for a given
group ID. An error will be returned if there is no pathway group associated
with the given ID. For a valid request, Pathway Group ID and named are
returned as key value pairs and the Indicators populate an array.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FpathwayGroup\%2F\%3Cpathway_group_id\%3E}{Indicator pathway group}
}
\examples{
# Return indicators for the 'Chronic Kidney Disease' Pathway Group (ID 9):
cvd_indicator_pathway_group(pathway_group_id = 9) |>
  dplyr::select(PathwayGroupName, PathwayGroupID, IndicatorCode, IndicatorID, IndicatorName)
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}},
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
