% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utilities.R
\name{sum_tile_settings}
\alias{sum_tile_settings}
\title{Create a list of settings for the sum tiles in plot_confusion_matrix()}
\usage{
sum_tile_settings(
  palette = NULL,
  label = NULL,
  tile_fill = NULL,
  font_color = NULL,
  tile_border_color = NULL,
  tile_border_size = NULL,
  tile_border_linetype = NULL,
  tc_tile_fill = NULL,
  tc_font_color = NULL,
  tc_tile_border_color = NULL,
  tc_tile_border_size = NULL,
  tc_tile_border_linetype = NULL,
  intensity_by = NULL,
  intensity_lims = NULL,
  intensity_beyond_lims = NULL
)
}
\arguments{
\item{palette}{Color scheme to use for sum tiles.
 Should be different from the \code{`palette`} used for the regular tiles.

 Passed directly to \code{`palette`} in
 \code{\link[ggplot2:scale_fill_distiller]{ggplot2::scale_fill_distiller}}.

 Try these palettes: \code{"Greens"}, \code{"Oranges"}, \code{"Greys"},
 \code{"Purples"}, \code{"Reds"}, and \code{"Blues"}.

 Alternatively, pass a named list with limits of a custom gradient as e.g.
 \code{`list("low"="#e9e1fc", "high"="#BE94E6")`}. These are passed to
 \code{\link[ggplot2:scale_fill_gradient]{ggplot2::scale_fill_gradient}}.

 Note: When \code{`tile_fill`} is specified, the \code{`palette`} is \strong{ignored}.}

\item{label}{The label to use for the sum column and the sum row.}

\item{tc_tile_fill, tile_fill}{Specific background color for the tiles. Passed as \emph{\code{`fill`}} to
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.

 If specified, the \code{`palette`} is ignored.}

\item{tc_font_color, font_color}{Color of the text in the tiles with the column and row sums.}

\item{tc_tile_border_color, tile_border_color}{Color of the tile borders. Passed as \emph{\code{`colour`}} to
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.}

\item{tc_tile_border_size, tile_border_size}{Size of the tile borders. Passed as \emph{\code{`size`}} to
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.}

\item{tc_tile_border_linetype, tile_border_linetype}{Linetype for the tile borders. Passed as \emph{\code{`linetype`}} to
\code{\link[ggplot2:geom_tile]{ggplot2::geom_tile}}.}

\item{intensity_by}{The measure that should control the color intensity of the tiles.
 Either \code{`counts`}, \code{`normalized`} or one of \code{`log counts`,
 `log2 counts`, `log10 counts`, `arcsinh counts`}.

 For `normalized`, the color limits become \code{0-100} (except when
 \code{`intensity_lims`} are specified), why the intensities
 can better be compared across plots.

 For the `log*` and `arcsinh` versions, the log/arcsinh transformed counts are used.

 \strong{Note}: In `log*` transformed counts, 0-counts are set to `0`, why they
 won't be distinguishable from 1-counts.}

\item{intensity_lims}{A specific range of values for the color intensity of
 the tiles. Given as a numeric vector with \code{c(min, max)}.

 This allows having the same intensity scale across plots for better comparison
 of prediction sets.}

\item{intensity_beyond_lims}{What to do with values beyond the
\code{`intensity_lims`}. One of \code{"truncate", "grey"}.}
}
\value{
List of settings.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

 Creates a list of settings for plotting the column/row sums
 in \code{\link[cvms:plot_confusion_matrix]{plot_confusion_matrix()}}.

 The \code{`tc_`} in the arguments refers to the \strong{total count} tile.

 NOTE: This is very experimental and will likely change.
}
\seealso{
Other plotting functions: 
\code{\link{font}()},
\code{\link{plot_confusion_matrix}()},
\code{\link{plot_metric_density}()},
\code{\link{plot_probabilities_ecdf}()},
\code{\link{plot_probabilities}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{plotting functions}
