#' Lung cancer data
#'
#' Lung cancer gene expression data set
#'
#' @docType data
#' @keywords datasets
#' @format This data set contain 56 samples and gene expression values of 200 out of 12 625 genes measured using the Affymetrix 95av2 GeneChip. The subset of genes had the 200 highest sample variances among the originally measured genes.
#' The samples comprise 20 pulmonary carcinoid samples (Carcinoid), 13 colon cancer metastasis samples (Colon), 17 normal lung samples (Normal) and 6 small cell lung carcinoma samples (SmallCell). The rownames are affymetrix gene ids.
#' @name lung
#' @usage data(lung)
#' @source http://www.pnas.org/content/98/24/13790/suppl/DC1
#' @references Bhattacharjee, A., Richards, W. G., Staunton, J., Li, C., Monti, S., Vasa, P., Ladd, C., Beheshti, J., Bueno, R., Gillette, M., Loda, M., Weber, G., Mark, E. J., Lander, E. S., Wong, W., Johnson, B. E., Golub, T. R., Sugarbaker, D. J., and Meyerson, M. (2001). Classification of human lung carcinomas by mRNA expression profiling reveals distinct adenocarcinoma subclasses. Proceedings of the National Academy of Sciences of the United States of America.
NULL
