% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxhull.R
\name{plotConvexHull3d}
\alias{plotConvexHull3d}
\title{Plot triangulated 3D convex hull}
\usage{
plotConvexHull3d(
  hull,
  edgesAsTubes = TRUE,
  verticesAsSpheres = TRUE,
  facesColor = "navy",
  edgesColor = "gold",
  tubesRadius = 0.03,
  spheresRadius = 0.05,
  spheresColor = edgesColor
)
}
\arguments{
\item{hull}{an output of \code{\link{cxhull}} applied to 3D points and 
with the option \code{triangulate=TRUE}}

\item{edgesAsTubes}{Boolean, whether to draw the edges as tubes}

\item{verticesAsSpheres}{Boolean, whether to draw the vertices as spheres}

\item{facesColor}{the color for the faces}

\item{edgesColor}{the color for the edges}

\item{tubesRadius}{the radius of the tubes when \code{edgesAsTubes=TRUE}}

\item{spheresRadius}{the radius of the spheres when 
\code{verticesAsSpheres=TRUE}}

\item{spheresColor}{the color of the spheres when 
\code{verticesAsSpheres=TRUE}}
}
\value{
No value.
}
\description{
Plot a triangulated 3D convex hull with \strong{rgl}.
}
\examples{
library(cxhull)
library(rgl)
dodecahedron <- t(dodecahedron3d()$vb[-4L, ])
hull <- cxhull(dodecahedron, triangulate = TRUE)
open3d(windowRect = c(50, 50, 562, 562))
plotConvexHull3d(hull)
}
