% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journey.R
\name{journey}
\alias{journey}
\title{Plan a journey with CycleStreets.net}
\usage{
journey(from, to, plan = "fastest", silent = TRUE, pat = NULL,
  base_url = "https://www.cyclestreets.net", reporterrors = TRUE,
  save_raw = "FALSE", cols = c("name", "distances", "time", "busynance",
  "elevations", "start_longitude", "start_latitude", "finish_longitude",
  "finish_latitude"))
}
\arguments{
\item{from}{Longitude/Latitude pair, e.g. \code{c(-1.55, 53.80)}}

\item{to}{Longitude/Latitude pair, e.g. \code{c(-1.55, 53.80)}}

\item{plan}{Text strong of either "fastest" (default), "quietest" or "balanced"}

\item{silent}{Logical (default is FALSE). TRUE hides request sent.}

\item{pat}{The API key used. By default this uses \code{Sys.getenv("CYCLESTREETS")}.}

\item{base_url}{The base url from which to construct API requests
(with default set to main server)}

\item{reporterrors}{Boolean value (TRUE/FALSE) indicating if cyclestreets (TRUE by default).
should report errors (FALSE by default).}

\item{save_raw}{Boolean value which returns raw list from the json if TRUE (FALSE by default).}

\item{cols}{Columns to be included in the result, a character vector or \code{NULL} for all available columns (see details for default)}
}
\description{
R interface to the CycleStreets.net journey planning API,
a route planner made by cyclists for cyclists.
See \href{https://www.cyclestreets.net/api/}{cyclestreets.net/api} for details.
}
\details{
Requires the internet and a CycleStreets.net API key.
CycleStreets.net does not yet work worldwide.

You need to have an api key for this code to run.
By default it uses the CYCLESTREETS environment variable.
This can be set with \code{usethis::edit_r_environ()}.

A full list of variables (\code{cols}) available is represented by:\preformatted{c("time", "busynance", "signalledJunctions", "signalledCrossings",
"name", "walk", "elevations", "distances", "start", "finish",
"startSpeed", "start_longitude", "start_latitude", "finish_longitude",
"finish_latitude", "crow_fly_distance", "event", "whence", "speed",
"itinerary", "clientRouteId", "plan", "note", "length", "quietness",
"west", "south", "east", "north", "leaving", "arriving", "grammesCO2saved",
"calories", "edition", "geometry")
}
}
\examples{
\dontrun{
from = c(-1.55, 53.80) # geo_code("leeds")
to = c(-1.76, 53.80) # geo_code("bradford uk")
r1 = journey(from, to)
sf:::plot.sf(r1)
to = c(-2, 53.5) # towards manchester
r1 = journey(from, to)
r2 = journey(from, to, plan = "balanced")
plot(r1["busynance"], reset = FALSE)
plot(r2["busynance"], add = TRUE)
r3 = journey(from, to, silent = FALSE)
r4 = journey(from, to, save_raw = TRUE)
r5 = journey(from, to, cols = NULL)
}
}
\seealso{
json2sf_cs
}
