% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d3po-graph.R
\name{d3po_graph}
\alias{d3po_graph}
\alias{po_nodes}
\alias{po_edges}
\alias{po_layout}
\title{Graph}
\usage{
po_nodes(d3po, ..., data = NULL, inherit_daes = TRUE)

po_edges(d3po, ..., data = NULL, inherit_daes = TRUE)

po_layout(d3po, method = igraph::layout_nicely)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}

\item{method}{The igraph function to compute node positions.}
}
\value{
Appends nodes arguments to a network-specific 'htmlwidgets' object
}
\description{
Customise edges and nodes.
}
\examples{
tr <- igraph::make_tree(40, children = 3, mode = "undirected")

d3po(tr) \%>\% 
 po_layout()

edges <- igraph::as_data_frame(tr, "edges")

d3po(daes(group = "name")) \%>\% 
 po_edges(data = edges)

}
