% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d3po-api.R
\name{po_area}
\alias{po_area}
\title{Area}
\usage{
po_area(d3po, ..., data = NULL, inherit_daes = TRUE, stack = FALSE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}

\item{stack}{Whether to stack the series.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Plot an area chart.
}
\examples{
library(dplyr)

pokemon_density <- density(pokemon$weight, n = 30)

pokemon_density <- tibble(
 x = pokemon_density$x,
 y = pokemon_density$y,
 variable = "weight",
 color = "#5377e3"
)

d3po(pokemon_density) \%>\%
 po_area(
  daes(x = x, y = y, group = variable, color = color)
 ) \%>\%
 po_title("Approximated Density of Pokemon Weight")

}
