% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objClass.R
\name{normL2}
\alias{normL2}
\title{L2 norm between data and model prediction}
\usage{
normL2(data, x, errmodel = NULL, times = NULL, attr.name = "data",
  loq = -Inf)
}
\arguments{
\item{data}{object of class \link{datalist}}

\item{x}{object of class \link{prdfn}}

\item{errmodel}{object of class \link{obsfn}. \code{errmodel} does not need to be defined for all conditions.}

\item{times}{numeric vector, additional time points where the prediction function is 
evaluated. If NULL, time points are extacted from the datalist solely. If the prediction
function makes use of events, hand over event \code{times} here.}

\item{attr.name}{character. The constraint value is additionally returned in an 
attributed with this name}

\item{loq}{named numeric or single valued numeric. Limit of quantification.}
}
\value{
Object of class \code{obsfn}, i.e. a function 
\code{obj(..., fixed, deriv, conditions, env)} that returns an objective list,
\link{objlist}.
}
\description{
For parameter estimation and optimization, an objective function
is needed. \code{normL2} returns an objective function for the L2 norm of
data and model prediction. The resulting objective function can be used for
optimization with the trust optimizer, see \link{mstrust}.
}
\details{
Objective functions can be combined by the "+" operator, see \link{sumobjfn}.
}
\examples{
## Generate a prediction function

times <- 0:5
grid <- data.frame(name = "A", time = times, row.names = paste0("p", times))
x <- Xd(grid, condition = "C1")

pars <- structure(rep(0, nrow(grid)), names = row.names(grid))

## Simulate data
data.list <- lapply(1:3, function(i) {
  prediction <- x(times, pars + rnorm(length(pars), 0, 1))
  cbind(wide2long(prediction), sigma = 1)
})

data <- as.datalist(do.call(rbind, data.list))

## Generate objective function based on data and model
## Then fit the data and plot the result
obj <- normL2(data, x)
myfit <- trust(obj, pars, rinit = 1, rmax = 10)
plot(x(times, myfit$argument), data)
}
