% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dPCPclustering.R
\name{dPCP}
\alias{dPCP}
\alias{plot.dPCP}
\title{Automated analysis of digital PCR data}
\usage{
dPCP(
  file,
  system = NULL,
  file.location = ".",
  reference.quality = 0.5,
  sample.quality = 0.5,
  eps = 200,
  minPts = 50,
  save.template = FALSE,
  rain = TRUE,
  QC.reference = FALSE,
  partition.volume = NULL
)

\method{plot}{dPCP}(
  x,
  ...,
  sample = "all",
  reference = "all",
  type = "dPCP",
  color.blind = FALSE
)
}
\arguments{
\item{file}{character. The name or the path of csv file to be read. If it
does not contain an absolute path, the file name is relative to the current
working directory, (\code{\link[base]{getwd}}).}

\item{system}{character. The name of digital PCR system used to generate
the data. It must be either Thermo Fisher or Bio-Rad. Abbreviations are
also accepted.}

\item{file.location}{character. Full path name to reference and sample
files location. The default corresponds to the working directory,
(\code{\link[base]{getwd}}). Tilde expansion (see
(\code{\link[base]{path.expand}})) is performed.}

\item{reference.quality}{numeric. Between 0 and 1. Quality threshold to
subset the data. If different thresholds have to be applied to various
reference samples, a vectror of the same length of number of reference
samples has to be provided. Used only when the \code{system} is Thermo
Fisher.}

\item{sample.quality}{numeric. Between 0 and 1. Quality threshold to subset
data. If different thresholds have to be applied to various samples, a
vectror of the same length of number of samples has to be provided. Used
only when the \code{system} is Thermo Fisher.}

\item{eps}{numeric. Input parameter for the DBSCAN algorithm.
It represents the maximum distance between the elements within a cluster.
See also \code{\link[dbscan]{dbscan}}. If different values have to be
applied to various reference samples, a vectror of the same length of
number of reference samples has to be provided.}

\item{minPts}{numeric. Input parameter for the DBSCAN algorithm.
It represents the number of minimum elements to assemble a cluster. See
also \code{\link[dbscan]{dbscan}}. If different values have to be
applied to various reference samples, a vectror of the same length of
number of reference samples has to be provided.}

\item{save.template}{logical. If TRUE a template of DBSCAN analysis of
reference samples is saved. When \code{system} is Thermo Fisher,
\code{save.template} can be also a character vector indicating the chipID.}

\item{rain}{logical. If TRUE the rain analysis is carried out.}

\item{QC.reference}{logical. If TRUE the fraction of rain elements in the
reference samples is carried out. Warning messages are displayed when the
percentage of rain is high.}

\item{partition.volume}{numeric. This parameters is taken into account when
the parameter 'system' is set on Other. Indicate the partion volume in
microliters spcific to the digital PCR system.}

\item{x}{an object of class \code{dPCP}}

\item{...}{Arguments to be passed to methods}

\item{sample}{'all' to show all samples, or a numeric vector indicating
the row number of samples in the sample table.}

\item{reference}{'all' to show all reference samples, or a character vector
with chip ID (Thermo Fisher) or the file name (Bio-rad) of reference
samples to be showed.}

\item{type}{string. Type of plot to be showed. Available plots:
'reference dbscan', 'centers', 'cmeans', 'rain', 'dPCP'.
@param color.blind logical. If TRUE colors optimized for colorblind
readers are used.}

\item{color.blind}{logical. If TRUE colors optimized for colorblind readers
are used.}
}
\value{
An object of class \code{dPCP} containing the following components:
  \item{referenceDB}{an object of class \code{reference_dbscan}.}
  \item{samples}{a list of samples. Each sample sublist contains the
  information about the cluster analysis.}
  \item{results}{an object of class \code{replicates_quant}.}
}
\description{
This function carries out the autometed clustering of digital PCR data.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata", package = "dPCP")

#dPCP analysis
results <- dPCP(sampleTable, system = "bio-rad", file.location = fileLoc,
                eps = 200, minPts = 50, save.template = FALSE, rain = TRUE,
                QC.reference = FALSE)

plot(results, sample = 1, type = "dPCP")
}
}
