% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extended_s3_methods.R
\name{logLik.fits_ids_dm}
\alias{logLik.fits_ids_dm}
\alias{AIC.fits_ids_dm}
\alias{BIC.fits_ids_dm}
\title{Extract Model Statistics for fits_ids_dm Object}
\usage{
\method{logLik}{fits_ids_dm}(object, ...)

\method{AIC}{fits_ids_dm}(object, ..., k = 2)

\method{BIC}{fits_ids_dm}(object, ...)
}
\arguments{
\item{object}{a \code{fits_ids_dm} object (see \link{estimate_model_ids})}

\item{...}{additional arguments}

\item{k}{numeric; penalty parameter for the AIC calculation.
Defaults to 2 (standard AIC).}
}
\value{
A data.frame containing the respective statistic in one column (named
\code{Log_Like}, \code{AIC}, or \code{BIC}) and a corresponding \code{ID} column.
}
\description{
These methods are wrappers to extract specific model fit statistics
(log-likelihood, AIC, BIC) for each model in a \code{fits_ids_dm} object.
}
\details{
Each function retrieves the relevant statistics by calling
\link{calc_stats} with \code{type = "fit_stats"} and selects the columns
for \code{ID} and the required statistic.
}
\examples{
# get an auxiliary fits_ids object for demonstration purpose;
# such an object results from calling load_fits_ids
all_fits <- get_example_fits_ids()

# AICs
AIC(all_fits)

# BICs
BIC(all_fits)

# Log-Likelihoods
logLik(all_fits)

# All unique and free parameters
coef(all_fits)

# Or all parameters across all conditions
coef(all_fits, select_unique = FALSE)

}
\seealso{
\code{\link[stats:AIC]{stats::AIC()}}, \code{\link[stats:AIC]{stats::BIC()}}, \link{logLik.drift_dm}
}
