% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{new_drift_dm}
\alias{new_drift_dm}
\title{Create A DDM model - Internal}
\usage{
new_drift_dm(
  flex_prms_obj,
  prms_solve,
  solver,
  comp_funs,
  subclass,
  b_coding = NULL,
  obs_data = NULL
)
}
\arguments{
\item{flex_prms_obj}{flex_prms object}

\item{prms_solve}{vector with sigma, t_max, dt, dx, nt, nx}

\item{solver}{string (e.g., kfe)}

\item{comp_funs}{a list of component functions}

\item{subclass}{string with model info label set for child class}

\item{b_coding}{optional list with b_coding (e.g., drift_dm_default_b_coding)}

\item{obs_data}{optional data.frame}
}
\value{
List with flex_prms_obj, prms_solve, solver, comp_funs. Attributes: class
info and b_encoding info. If obs_data is not null, then list of observed rts
see \code{\link[=obs_data]{obs_data()}}.
}
\description{
This function takes all objects/vectors to create a ddm object
}
\details{
This function does not perform any input checks and just assembles all
arguments. Pre-wrangling of each argument is done in \code{\link[=drift_dm]{drift_dm()}}.
Checks are done done with \code{\link[=validate_drift_dm]{validate_drift_dm()}}, called in
\code{\link[=drift_dm]{drift_dm()}}.
}
\keyword{internal}
