% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_processing.R
\name{traceplots.dalmatian}
\alias{traceplots.dalmatian}
\title{Traceplots (dalmatian)}
\usage{
\method{traceplots}{dalmatian}(object, family = NULL,
  nstart = start(object$coda), nend = end(object$coda),
  nthin = thin(object$coda), plot = TRUE, ...)
}
\arguments{
\item{object}{Object of class \code{dalmatian} created by \code{dalmatian()}.}

\item{family}{String defining selected family of variables (see help for \code{ggs()}).}

\item{nstart}{Start point for computing summary statistics (relative to true start of chain).}

\item{nend}{End point for computing summary statistics (relative to true start of chain).}

\item{nthin}{Thinning factor for computing summary statsitics (relative to full chain and not previously thinned output).}

\item{plot}{If TRUE then generate plots. Otherwise, a list of \code{ggplot} objects will be returned.}

\item{...}{Ignored}
}
\value{
A list of \code{ggplot} objects that can be used to later reproduce the plots via \code{print}.
}
\description{
Construct traceplots for key (or selected) parameters in a dalmatian object.
}
\examples{

## Load output from previously run model
load(system.file("Pied_Flycatchers_1","pfresults.RData",package="dalmatian"))

## Generate traceplots
pftraceplots <- traceplots(pfresults)

}
