% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_tune.R
\name{cla_tune}
\alias{cla_tune}
\title{Classification Tune}
\usage{
cla_tune(base_model, folds = 10, metric = "accuracy")
}
\arguments{
\item{base_model}{base model for tuning}

\item{folds}{number of folds for cross-validation}

\item{metric}{metric used to optimize}
}
\value{
returns a \code{cla_tune} object
}
\description{
This function performs a grid search or random search over specified hyperparameter values to optimize a base classification model
}
\examples{
# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

# hyper parameter setup
tune <- cla_tune(cla_mlp("Species", levels(iris$Species)))
ranges <- list(size=c(3:5), decay=c(0.1))

# hyper parameter optimization
model <- fit(tune, train, ranges)

# testing optimization
test_prediction <- predict(model, test)
test_predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, test_predictand, test_prediction)
test_eval$metrics
}
