% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_psa_samp.R
\name{dirichlet_params}
\alias{dirichlet_params}
\title{Calculate alpha parameters of Dirichlet distribution.}
\usage{
dirichlet_params(p.mean, sigma)
}
\arguments{
\item{p.mean}{Vector of means of the random variables.}

\item{sigma}{Vector of standard deviation of the random variables
(i.e., standard error).}
}
\value{
numeric vector of method-of-moment estimates for the alpha parameters of the
 dirichlet distribution
}
\description{
Function to calculate the \eqn{\alpha} parameters of the Dirichlet distribution
based on the method of moments (MoM) using the mean \eqn{\mu} and standard
deviation \eqn{\sigma} of the random variables of interest.
}
\section{Details}{

Based on methods of moments. If \eqn{\mu} is a vector of means and
\eqn{\sigma} is a vector of standard deviations of the random variables, then
the second moment \eqn{X_2} is defined by \eqn{\sigma^2 + \mu^2}. Using the
mean and the second moment, the \eqn{J} alpha parameters are computed as follows
\deqn{\alpha_i = \frac{(\mu_1-X_{2_{1}})\mu_i}{X_{2_{1}}-\mu_1^2}}
for \eqn{i = 1, \ldots, J-1}, and
\deqn{\alpha_J = \frac{(\mu_1-X_{2_{1}})(1-\sum_{i=1}^{J-1}{\mu_i})}{X_{2_{1}}-\mu_1^2}}
}

\examples{
p.mean <- c(0.5, 0.15, 0.35)
p.se   <- c(0.035, 0.025, 0.034)
dirichlet_params(p.mean, p.se)
}
\references{
\enumerate{
\item Fielitz BD, Myers BL. Estimation of parameters in the beta distribution.
Dec Sci. 1975;6(1):1–13.
\item Narayanan A. A note on parameter estimation in the multivariate beta
distribution. Comput Math with Appl. 1992;24(10):11–7.
}
}
\keyword{dirichlet}
\keyword{distribution;}
\keyword{method}
\keyword{moments}
\keyword{of}
