% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link-dam-metadata.R
\name{link_dam_metadata}
\alias{link_dam_metadata}
\alias{link_dam2_metadata}
\title{Link DAM2 or DAM5 metadata to result files}
\usage{
link_dam_metadata(x, result_dir)
}
\arguments{
\item{x}{object such as a \link{data.frame}, or the name of a file (see detail)}

\item{result_dir}{the root directory where all daily data are saved}
}
\value{
a \link[data.table:data.table]{data.table::data.table} with the same rows as x, and extra columns used for further data loading
}
\description{
This function checks and add columns to DAMS metadata.
This way, it can subsequently be loaded (via \link{load_dam}).
}
\details{
These function will augment metadata from two different types of inputs:
\enumerate{
\item A \link{data.frame} (recommended)
In this case, the function will try to match requested data with data available on \code{result_dir}.
The provided \link{data.frame} or \link{data.table} has typically one row per requested individual and the columns
(not necessarily in this order):
\itemize{
\item \code{file} -- the name of a data file (e.g. \code{"Monitor3.txt"}), it has to exists in result_dir.
\item \code{start_datetime} -- the first day \strong{and time} of the requested experiment (e.g. \code{"2014-12-28 18:00:00"}).
\item \code{stop_datetime} -- the last day and time of the requested experiment (e.g. \code{"2014-12-30  19:00:00"} or simply \code{"2014-12-30"}).
\item \code{region_id} -- the channel (between 1 and 32) in which the animal was in (e.g. \code{20}).
\code{region_id} is optional. If not provided, all 32 channels are loaded \emph{with the same conditions}.
\item \verb{???} \emph{any number of arbitrary columns} to associate \code{conditions}/\code{treatments}/\code{genotypes}/... to the previous columns.
}
\item The name of a CSV file that contains a table as described in \code{1}.
}

The time in data is expressed relatively to start_date.
In other words, if you do circadian analysis, and your \code{D -> L} transitions are at 09:00:00,
you want to set \code{start_datetime = "YYY-MM-DD 09:00:00"}.
The \verb{result_directory`` is the folder conraining all result (.txt) files (for instance, }result_dir = "C:/where/I/Store/my/txt/files/"`)
}
\references{
\itemize{
\item \href{https://rethomics.github.io/workflow.html}{the rethomics workflow} -- on the concept of "linking"
\item \href{https://rethomics.github.io/metadata.html}{metadata tutorial} -- how to work with metadata
}
}
\seealso{
\itemize{
\item \link{load_dam} -- to subsequently load the actual data
}
}
