% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.overshoot.r
\name{gl.filter.overshoot}
\alias{gl.filter.overshoot}
\title{Filters loci for which the SNP has been trimmed from the sequence tag
along with the adaptor}
\usage{
gl.filter.overshoot(x, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A new genlight object with the recalcitrant loci deleted
}
\description{
This function checks the position of the SNP within the trimmed sequence tag
and identifies those for which the SNP position is outside the trimmed
 sequence tag. This can happen, rarely, when the sequence containing the SNP
 resembles the adaptor.
The SNP genotype can still be used in most analyses, but functions like
gl2fasta() will present challenges if the SNP has been trimmed from the
sequence tag.
Not fatal, but should apply this filter before gl.filter.secondaries, for
obvious reasons.
}
\examples{
result <- gl.filter.overshoot(testset.gl, verbose=3)

}
\seealso{
Other matched filter: 
\code{\link{gl.filter.callrate}()},
\code{\link{gl.filter.hamming}()},
\code{\link{gl.filter.ld}()},
\code{\link{gl.filter.locmetric}()},
\code{\link{gl.filter.maf}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.pa}()},
\code{\link{gl.filter.secondaries}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched filter}
