% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.reset.flags.r
\name{utils.reset.flags}
\alias{utils.reset.flags}
\title{#' An internal utility function to reset to FALSE (or TRUE) the locus metric flags after
some individuals or populations have been deleted.}
\usage{
utils.reset.flags(x, set = FALSE, value = 2, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{set}{Set the flags to TRUE or FALSE [default FALSE].}

\item{value}{Set the default verbosity for all functions, where verbosity is
not specified [default 2].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity]}
}
\value{
The modified genlight object
}
\description{
WARNING: UTILITY SCRIPTS ARE FOR INTERNAL USE ONLY AND SHOULD NOT BE USED BY END USERS AS THEIR USE OUT OF CONTEXT COULD LEAD TO UNPREDICTABLE OUTCOMES.
}
\details{
The locus metadata supplied by DArT has OneRatioRef, OneRatioSnp, PICRef,
PICSnp, and AvgPIC included, but the allelic composition will change when
some individuals are removed from the dataset and so the initial statistics
will no longer apply. This applies also to some variable calculated by dartR
(e.g. maf). This script resets the locus metrics flags to FALSE to indicate
that these statistics in the genlight object are no longer current. The
verbosity default is also set, and in the case of SilcoDArT, the flags PIC
and OneRatio are also set.
If the locus metrics do not exist then they are added to the genlight object
 but not populated. If the locus metrics flags do not exist, then they are
 added to the genlight object and set to FALSE (or TRUE).
}
\examples{
result <- utils.reset.flags(testset.gl)

}
\seealso{
\code{utils.recalc.metrics} for recalculating all metrics,
\code{utils.recalc.callrate} for recalculating CallRate,
\code{utils.recalc.freqhomref} for recalculating frequency of homozygous
reference, \code{utils.recalc.freqhomsnp} for recalculating frequency of
homozygous alternate, \code{utils.recalc.freqhet} for recalculating frequency
of heterozygotes, \code{gl.recalc.maf} for recalculating minor allele 
frequency, \code{gl.recalc.rdepth} for recalculating average read depth

Other utilities: 
\code{\link{gl.alf}()},
\code{\link{utils.check.datatype}()},
\code{\link{utils.dart2genlight}()},
\code{\link{utils.dist.binary}()},
\code{\link{utils.flag.start}()},
\code{\link{utils.hamming}()},
\code{\link{utils.het.pop}()},
\code{\link{utils.impute}},
\code{\link{utils.is.fixed}()},
\code{\link{utils.jackknife}()},
\code{\link{utils.n.var.invariant}()},
\code{\link{utils.plot.save}()},
\code{\link{utils.read.fasta}()},
\code{\link{utils.read.ped}()},
\code{\link{utils.recalc.avgpic}()},
\code{\link{utils.recalc.callrate}()},
\code{\link{utils.recalc.freqhets}()},
\code{\link{utils.recalc.freqhomref}()},
\code{\link{utils.recalc.freqhomsnp}()},
\code{\link{utils.recalc.maf}()},
\code{\link{utils.transpose}()}
}
\author{
Custodian: Luis Mijangos (Post to
\url{https://groups.google.com/d/forum/dartr})
}
\concept{utilities}
