% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.add.indmetrics.r
\name{gl.add.indmetrics}
\alias{gl.add.indmetrics}
\title{Adds metadata into a genlight object}
\usage{
gl.add.indmetrics(x, ind.metafile, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data, or the genind
object containing the SilocoDArT data [required].}

\item{ind.metafile}{path and name of CSV file containing the metadata
information for each individual (see details for explanation) [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A genlight object with metadata information for each individual.
}
\description{
This function adds the metadata information to the slot ind.metrics and
populates population and coordinates information slots if the they are
found in the metadata.
}
\details{
The ind.metadata file needs to have very specific headings. First a column
with a heading named 'id'. Here the ids must match the ids in the genlight
 object, e.g. \code{indNames(your_genlight)}. The following column headings
 are optional:
 \itemize{
 \item 'pop' - specifies the population membership of each individual.
 \item 'lat' - latitude coordinates (in decimal degrees WGS1984 format).
 \item 'lon' - longitude coordinates (in decimal degrees WGS1984 format).
 }

 Additional columns with individual metadata can be imported (e.g. age,
 sex, etc).
}
\examples{
dartfile <- system.file('extdata','testset_SNPs_2Row.csv', package='dartR.data')
metadata <- system.file('extdata','testset_metadata.csv', package='dartR.data')
gl <- gl.read.dart(dartfile, probar=TRUE)
gl <- gl.add.indmetrics(gl, ind.metafile = metadata)
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
