% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.secondaries.r
\name{gl.filter.secondaries}
\alias{gl.filter.secondaries}
\title{Filter loci that represent secondary SNPs in a genlight \{adegenet\} object}
\usage{
gl.filter.secondaries(gl)
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP data [required]}
}
\value{
The reduced genlight, plus a summary
}
\description{
SNP datasets generated by DArT include fragments with more than one SNP and record them separately with the same CloneID (=AlleleID).
These multiple SNP loci within a fragment (secondaries) are likely to be linked, and so you may wish to remove secondaries.
This script filters out loci after ordering the genlight object on based on reproducibility, PIC in that order.
}
\examples{
result <- gl.report.secondaries(testset.gl)
result2 <- gl.filter.secondaries(testset.gl)
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
