% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2phylip.r
\name{gl2phylip}
\alias{gl2phylip}
\title{Create a Phylip input distance matrix from a genlight (SNP) or genind (SilicoDarT) \{adegenet\} object}
\usage{
gl2phylip(gl, outfile = "phyinput.txt", outpath = tempdir(), bstrap = 1)
}
\arguments{
\item{gl}{Name of the genlight object containing the SNP data or a genind object containing presence absence data [required]}

\item{outfile}{Name of the file to become the input file for phylip [default phyinput.txt]}

\item{outpath}{path where to save the output file (set to tempdir by default)}

\item{bstrap}{Number of bootstrap replicates [default 1]}
}
\value{
Matrix of Euclidean distances between populations
}
\description{
This function calculates and returns a matrix of Euclidean distances between populations
and produces an input file for the phylogenetic program Phylip (Joe Felsenstein).
}
\examples{
\donttest{
result <- gl2phylip(testset.gl, outfile="test.txt", bstrap=10)
}
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
