% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.collapse.r
\name{gl.collapse}
\alias{gl.collapse}
\title{Collapse a distance matrix by amalgamating populations with pairwise fixed difference count 
less that a threshold}
\usage{
gl.collapse(fd, tpop = 0, tloc = 0, pb = FALSE, verbose = NULL)
}
\arguments{
\item{fd}{-- name of the list of matricies produced by gl.fixed.diff() [required]}

\item{tpop}{-- threshold number of fixed differences above which populatons will not be 
amalgamated [0]}

\item{tloc}{-- threshold defining a fixed difference (e.g. 0.05 implies 95:5 vs 5:95 is fixed) [0]}

\item{pb}{-- if TRUE, show a progress bar on time consuming loops [FALSE]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 
3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
A list containing the gl object x and the following square matricies
        [[1]] $gl -- the new genlight object with populations collapsed;
        [[2]] $fd -- raw fixed differences;
        [[3]] $pcfd -- percent fixed differences;
        [[4]] $nobs -- mean no. of individuals used in each comparison;
        [[5]] $nloc -- total number of loci used in each comparison;
        [[6]] $expfpos -- NA's, populated by gl.fixed.diff [by simulation]
        [[7]] $expfpos -- NA's, populated by gl.fixed.diff [by simulation]
        [[8]] $prob -- NA's, populated by gl.fixed.diff [by simulation]
}
\description{
This script takes a the file generated by gl.fixed.diff and amalgamates populations with 
distance less than or equal to a specified threshold. The distance matrix is generated by 
gl.fixed.diff().
}
\details{
The script then applies the new population assignments to the genlight object and recalculates 
the distance and associated matricies.
}
\examples{
fd <- gl.fixed.diff(testset.gl,tloc=0.05)
fd
fd2 <- gl.collapse(fd,tpop=1)
fd2
fd3 <- gl.collapse(fd2,tpop=1)
fd3
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
