% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.plot.structure.r
\name{gl.plot.structure}
\alias{gl.plot.structure}
\title{Plots a STRUCTURE analysis using a genlight object}
\usage{
gl.plot.structure(sr, k, sort = NULL, CLUMPP = "./", ..., plot_theme, verbose)
}
\arguments{
\item{sr}{structure run object from \code{\link{gl.run.structure}} [required].}

\item{k}{the number for k the q matrix should be based on. Needs to
be within you simulated range of k's in your sr structure run object.}

\item{sort}{how q matrix is sorted (by population, group proportion etc.)
[default is by the population definition and group proportion from group
 1 to k-1, meaning first sorted by group, then by proportion of group 1,
  then group 2,.... then group k-1].}

\item{CLUMPP}{path to the clumpp executable file. Windows: CLUMPP.exe,
macos and linux: CLUMPP (no exe).}

\item{...}{additional parameter passed to the clumpp function within
package strataG (\code{clumpp}).}

\item{plot_theme}{Theme for the plot. See details for options [default
theme_dartR()].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report [default
 NULL, unless specified using gl.set.verbosity]}
}
\value{
a barplot in ggplot format
}
\description{
This function takes a structure run object (output from
 \code{\link{gl.run.structure}}) and plots the typical strcture bar
  plot that visiualise the q matrix of a structure run.
}
\details{
The function outputs a barplot which is the typical output of
 structure. This function needs the use of clumpp, which is an external
  program that needs to be installed For a evanno plot use gl.evanno.
}
\examples{
\dontrun{
#CLUMPP needs to be installed to be able to run the example
#bc <- bandicoot.gl[,1:100]
#sr <- gl.run.structure(bc, k.range = 2:5, num.k.rep = 3, exec = './structure.exe')
#ev <- gl.evanno(sr)
#ev
#qmat <- gl.plot.structure(sr, k=3, CLUMPP='d:/structure/')
#head(qmat)
#gl.map.structure(qmat, bc, scalex=1, scaley=0.5)
}
}
\references{
\itemize{
\item Pritchard, J.K., Stephens, M., Donnelly, P. (2000) Inference of
population structure using multilocus genotype data. Genetics 155, 945-959.
\item Archer, F. I., Adams, P. E. and Schneiders, B. B. (2016) strataG: An R
package for manipulating, summarizing and analysing population genetic data.
Mol Ecol Resour. doi:10.1111/1755-0998.12559
\item Mattias Jakobsson and Noah A. Rosenberg. 2007. CLUMPP: a cluster
matching and permutation program for dealing with label switching and
multimodality in analysis of population structure. Bioinformatics
23(14):1801-1806. Available at
\href{http://web.stanford.edu/group/rosenberglab/clumppDownload.html}{clumpp}
}
}
\seealso{
\code{gl.run.structure},  \code{clumpp}, \code{gl.plot.structure}
}
\author{
Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
