% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sort.r
\name{gl.sort}
\alias{gl.sort}
\title{re-sorts genlight objects}
\usage{
gl.sort(x, sort.by = "pop", order.by = NULL, verbose = NULL)
}
\arguments{
\item{x}{genlight object containing SNP/silicodart genotypes}

\item{sort.by}{either "ind", "pop". Default is pop}

\item{order.by}{that is used to order individuals or loci. Depening on the order.by parameter, this needs to be a vector of length of nPop(genlight) for populations or  nInd(genlight) for individuals. If not specified alphabetical order of populations or individuals is used. For sort.by="ind" order.by can be also a vector specifying the order for each individual (for example another ind.metrics)}

\item{verbose}{set verbosity}
}
\value{
Returns a reordered genlight object. Sorts also the ind/loc.metrics and coordinates accordingly
}
\description{
Often it is desirable to have the genlight object sorted individuals by population names, indiviual name, for example to have a more informative gl.smearplot (showing banding patterns for populations). Also sorting by loci can be informative in some instances. This function provides the ability to sort individuals of a genlight object by providing the order of individuals or populations and also by loci metric providing the order of locis. See examples below for specifics.
}
\details{
This is convenience function to facilitate sorting of individuals within the genlight object. For example if you want to visualise the "band" of population in a gl.smearplot then the order of individuals is important. Also
}
\examples{
#sort by populations
bc <- gl.sort(bandicoot.gl)
#sort from West to East
bc2 <- gl.sort(bandicoot.gl, sort.by="pop" ,
order.by=c("WA", "SA", "VIC", "NSW", "QLD"))
#sort by missing values
miss <- rowSums(is.na(as.matrix(bandicoot.gl)))
bc3 <- gl.sort(bandicoot.gl, sort.by="ind", order.by=miss)
gl.smearplot(bc3)
}
\seealso{
Other base dartR: 
\code{\link{gl.sample}()}
}
\author{
Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{base dartR}
