% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateCss_cssGradientThreeColors.R
\name{cssGradientThreeColors}
\alias{cssGradientThreeColors}
\title{cssGradientThreeColors}
\usage{
cssGradientThreeColors(
  direction = "down",
  colorStart,
  colorMiddle,
  colorEnd,
  colorStartPos = 0,
  colorMiddlePos = 50,
  colorEndPos = 100
)
}
\arguments{
\item{direction}{String. Direction of the gradient (down/right). Defaults to down.}

\item{colorStart}{String. Start (top/left) colour of the gradient.}

\item{colorMiddle}{String. Middle colour of the gradient.}

\item{colorEnd}{String. End (bottom/right) colour of the gradient.}

\item{colorStartPos}{Numeric. Position of the start colour. Defaults to 0.}

\item{colorMiddlePos}{Numeric. Position of the middle colour. Defaults to 50.}

\item{colorEndPos}{Numeric. Position of the end colour; defaults to 100.}
}
\value{
CSS code. Gradient with three colors.
}
\description{
Generates CSS code for a gradient with three colors
}
\examples{
\donttest{
cssGradientThreeColors(
  direction = "right"
  ,colorStart = "rgba(44,222,235,1)"
  ,colorMiddle = "rgba(44,222,235,1)"
  ,colorEnd = "rgba(0,255,213,1)"
  ,colorStartPos = 0
  ,colorMiddlePos = 30
  ,colorEndPos = 100
)
}
}
\seealso{
\code{\link{shinyDashboardThemeDIY}, \link{shinyDashboardLogoDIY}},
}
