% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/node.R
\name{Set}
\alias{Set}
\title{Traverse a Tree and Assign Values}
\usage{
Set(..., traversal = "pre-order", returnValues = FALSE)
}
\arguments{
\item{...}{each argument can be a vector of values to be assigned.}

\item{traversal}{any of 'pre-order', 'post-order', 'ancestor'}

\item{returnValues}{if \code{TRUE}, then the non-processed arg passed in ... are returned.
Otherwise the \code{Node} itself is returned for chaining. Mainly for internal use.}
}
\description{
The method takes a vector as an argument. It traverses the tree, and assigns values to variables, whereby the values are picked
from the vector.
}
\examples{
data(acme)
acme$Set(departmentId = 1:11,
         head = c("Jack Brown",
                  "Dr. Frank N. Stein",
                  "",
                  "",
                  "Mona Moneyhead",
                  "",
                  "",
                  "Eric Nerdahl",
                  "",
                  "",
                  ""))
print(acme, "departmentId", "head")
}
\seealso{
\code{\link{Node}}
}
\keyword{internal}

