% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/node_methods.R
\name{Aggregate}
\alias{Aggregate}
\title{Aggregate child values of a \code{Node}, standalone or in traversal.}
\usage{
Aggregate(node, attribute, aggFun, cacheAttribute = NULL, ...)
}
\arguments{
\item{node}{the \code{Node} on which to aggregate}

\item{attribute}{determines what is collected. The \code{attribute} can be
\itemize{
  \item a.) the name of a \bold{field} of each \code{Node} in the tree
  \item b.) the name of a \bold{method} of each \code{Node} in the tree
  \item c.) a \bold{function}, whose first argument must be a \code{Node}
 }}

\item{aggFun}{the aggregation function to be applied to the children's \code{attributes}}

\item{cacheAttribute}{the name to which results should be stored, if any (NULL otherwise). If not
NULL, then the function checks whether this attribute is set, and only evaluates
attribute if it is not.
If used wisely in connection with post-order traversal, this parameter allows to speed up calculation by breaking
recursion.}

\item{...}{any arguments to be passed on to attribute (in case it's a function)}
}
\description{
The \code{Aggregate} method lets you fetch an attribute from a \code{Node}'s children, and then aggregate it.
For example, you can aggregate cost by summing costs of child \code{Nodes}. This is especially useful in the
context of tree traversal, when using post-order traversal mode.
}
\details{
As with \code{\link{Get}}, the attribute can be a field, a method or a function. If it is a field, and if
the node contains the attribute, its value is returned.
Otherwise, \code{aggFun(Aggregate(children, ...))} is called. In that case,
the attribute must be set on the leaf.
}
\examples{
data(acme)

#Aggregate on a field
Aggregate(acme, "cost", sum)

#Aggregate using Get
print(acme, "cost", minCost = acme$Get(Aggregate, "cost", min))

#use Aggregate with caching:
acme$cost
acme$Do(function(x) Aggregate(x, "cost", sum, cacheAttribute = "cost"), traversal = "post-order")
acme$cost

#use Aggregate with a function:
acme$Do(function(x) x$expectedCost <- Aggregate(x,
                                                function(x) x$cost * x$p,
                                                sum)
       , traversal = "post-order")
}
\seealso{
\code{\link{Node}}
}

