% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_comp_report_fct_display.R
\name{compare_data_frame_object_report}
\alias{compare_data_frame_object_report}
\title{run the rmarkdown report of the data comparison and save it in an external directory}
\usage{
compare_data_frame_object_report(
  df1,
  df2,
  ids,
  report_title = "Comparator report",
  report_author = "Author name here",
  report_context = "Add a small text here to explain the context."
)
}
\arguments{
\item{df1}{The first dataframe of the comparison}

\item{df2}{The second dataframe of the comparison}

\item{ids}{The character vector containing id variables which identify the observations in dataframe `df1` and datafram `df2`}

\item{report_title}{A character string which contains the title of the report}

\item{report_author}{A character string which contains the name of the report author}

\item{report_context}{A character string containing the context of the report}
}
\value{
null.
}
\description{
run the rmarkdown report of the data comparison and save it in an external directory
}
\examples{
library(dplyr)
compare_data_frame_object_report(
     df1 = iris \%>\% dplyr::mutate(ID = row_number()), 
     df2 = iris \%>\% dplyr::mutate(ID = row_number()), 
     ids = 'ID',
     report_title = "Iris data Comparator report",
     report_author = "Sergio Ewane",
     report_context = "i'm checking if the two dataframe contains the same values"
     )

}
