% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowFiltering.R
\name{remove_rare_categorical}
\alias{remove_rare_categorical}
\title{Filter rare categoricals}
\usage{
remove_rare_categorical(
  dataSet,
  cols = "auto",
  threshold = 0.01,
  verbose = TRUE
)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{List of column(s) name(s) of dataSet to transform. To transform all 
columns, set it to "auto".  (character, default to "auto")}

\item{threshold}{share of occurencies under which row should be removed (numeric, default to 0.01)}

\item{verbose}{Should the algorithm talk? (logical, default to TRUE)}
}
\value{
Same dataset with less rows, edited by \strong{reference}. \cr
If you don't want to edit by reference please provide set \code{dataSet = copy(dataSet)}.
}
\description{
Filter rows that have a rare occurences
}
\details{
Filtering is made column by column, meaning that extrem values from first element
of \code{cols} are removed, then extrem values from second element of \code{cols} are removed, 
... \cr
So if filtering is perfomed on too many column, there ia high risk that a lot of rows will be dropped.
}
\examples{
# Given a set with rare "C"
library(data.table)
dataSet <- data.table(cat_col = c(sample(c("A", "B"), 1000, replace=TRUE), "C"))

# When calling function
dataSet <- remove_rare_categorical(dataSet, cols = "cat_col",  
                                   threshold = 0.01, verbose = TRUE)
                                   
# Then there are no "C"
unique(dataSet[["cat_col"]])
}
