% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addWaterYear.R
\name{addWaterYear}
\alias{addWaterYear}
\title{add a water year column}
\usage{
addWaterYear(rawData)
}
\arguments{
\item{rawData}{the daily- or unit-values datset retrieved from NWISweb. Must
have at least one of the following columns to add the new water year columns:
`dateTime`, `Date`, `ActivityStartDate`, or `ActivityEndDate`. The date column(s)
can be character, POSIXct, Date. They cannot be numeric.}
}
\value{
data.frame with an additional integer column with "WY" appended to the 
date column name. For WQP, there will be 2 columns: `ActivityStartDateWY` and 
`ActivityEndDateWY`.
}
\description{
Add a column to the dataRetrieval data frame with the water year. WQP 
queries will return a water year column for the start and end dates
of the data.
}
\examples{
\dontrun{ 
dataTemp <- readNWISdata(stateCd="OH",parameterCd="00010", service="dv")
dataTemp <- addWaterYear(dataTemp)

pHData <- readWQPdata(siteid="USGS-04024315",characteristicName="pH")
pHData <- addWaterYear(pHData)
}
}
