% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_by_name.R
\name{get_session_by_name}
\alias{get_session_by_name}
\title{Get Session (Slot) Data From A Databrary Volume By Session Name.}
\usage{
get_session_by_name(
  session_name = "Advisory Board Meeting",
  vol_id = 1,
  vb = FALSE,
  rq = NULL
)
}
\arguments{
\item{session_name}{A string. The name of the target session. Defaults to "Advisory
Board Meeting", the name of several of the sessions in the public Volume 1.}

\item{vol_id}{An integer indicating the volume identifier. Default is 1.}

\item{vb}{A logical value. Show verbose feedback. Default is FALSE.}

\item{rq}{An httr2 request, such as that generated by \code{make_default_request()}.}
}
\value{
One or more JSON blobs (as lists) whose session name(s) match
\code{name} in the given volume.
}
\description{
Get Session (Slot) Data From A Databrary Volume By Session Name.
}
\examples{
\donttest{
\dontrun{
# Returns multiple JSON blobs with the name "Advisory Board Meeting" in Volume 1.
get_session_by_name() 

get_session_by_name(name = 'Top-level materials')
}
}
}
