% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_session_asset_fr_df.R
\name{download_session_asset_fr_df}
\alias{download_session_asset_fr_df}
\title{Download Single Asset From Databrary}
\usage{
download_session_asset_fr_df(
  asset_id = NULL,
  file_name = NULL,
  session_id = NULL,
  target_dir = file.path(tempdir(), session_id),
  overwrite = TRUE,
  vb = FALSE,
  rq = NULL
)
}
\arguments{
\item{asset_id}{An integer. Asset id for target file. Default is NULL.}

\item{file_name}{A character string. Name for downloaded file. Default is NULL.}

\item{session_id}{An integer. Slot/session number where target file is
stored. Default is 9807.}

\item{target_dir}{A character string. Directory to save the downloaded file.
Default is a temporary directory given by a call to \code{tempdir()}.}

\item{overwrite}{A logical value. Overwrite an existing file. Default is TRUE.}

\item{vb}{A logical value. If TRUE provides verbose output. Default is FALSE.}

\item{rq}{A list in the form of an \code{httr2} request object. Default is NULL.}
}
\value{
Full file name to the asset or NULL.
}
\description{
Databrary stores file types (assets) of many types. This
function downloads an asset based on its system-unique integer identifer
(asset_id) and system-unique session (slot) identifier (session_id). It
is designed to work with download_session_assets_fr_df() so that multiple
files can be downloaded simultaneously.
}
\examples{
\donttest{
\dontrun{
vol_1 <- list_session_assets(session_id = 9807)
a_1 <- vol_1[1,]
tmp_dir <- tempdir()
fn <- file.path(tmp_dir, paste0(a_1$asset_name, ".", a_1$format_extension))
download_session_asset_fr_df(a_1$asset_id, 
  fn, 
  session_id = a_1$session_id,
  vb = TRUE)

}
}
}
