% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/K9_events.R
\name{k9_events}
\alias{k9_events}
\title{Get Events}
\usage{
k9_events(event_id = NULL, start = NULL, end = NULL, priority = NULL,
  sources = NULL, tags = NULL)
}
\arguments{
\item{event_id}{Event ID.}

\item{start}{POSIX timestamp.}

\item{end}{POSIX timestamp.}

\item{priority}{Priority of events. \code{NULL}, \code{"low"} or \code{"normal"}.}

\item{sources}{Sources of events. A \code{character} vector or a single comma-separated \code{character}.}

\item{tags}{Tags of events. A named \code{list} or a single comma-separated \code{character}.}
}
\description{
This end point allows you to query for event details.
}
\examples{
\dontrun{
# by default get all events happend from an hour ago
k9_events()

# get all events happend in this week
k9_events(start = Sys.Date() - 7, end = Sys.Date())

# specify an event by ID
k9_events(event_id = "112233445566")

# specify tag
k9_events(tags = list(role = "db"))
}

}
\seealso{
\url{http://docs.datadoghq.com/api/?lang=console#events}
}
