% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{demograph}
\alias{demograph}
\title{Contains information of demography of species.}
\format{
Contains 15 variables, as follows:
\describe{
\item{species}{Name specie.}
\item{site}{Name of site of study.}
\item{country}{Name of country.}
\item{site.num}{Code of site.}
\item{code}{Species code.}
\item{genus}{Species genus.}
\item{spp}{Abbreviated name of the species.}
\item{family}{Family of the species.}
\item{phyl}{Type of phylogeny: Angiosperm/Gymnosperm}
\item{l.hab}{Leaf habit: Deciduous/Evergreen}
\item{l.type}{.}
\item{leaf}{Combination of phylogeny and leaf habit: evergreen gymnosperms; deciduous
 angiosperms and evergreen angiosperms.}
\item{growth.l}{Growth at full light, in years. Defined as the time needed for
 a sapling with DBH= 1cm to become an adult (DBH=7.5 cm) when light = 100\%.}
\item{growth.d}{Growth in shade, in years. Defined as the time needed for a 
sapling with DBH= 1cm to become an adult (DBH=7.5 cm) when light = 1\%}
\item{surv.d}{Survival in shade, in \%. Defined as the 5-year survivorship of a sapling
 with DBH = 1cm when light = 1\%.}
 }
}
\source{
The data were obtained from the DRYAD repository \doi{10.5061/dryad.12b0h}.
}
\usage{
data(demograph)
}
\description{
Dataset contains 61 observations about life histories values for each species and site,
 as obtained from the parameterization carried out in studies that used the model SORTIE
}
\examples{
data(demograph)    
head(demograph) 
}
\references{
- Ameztegui A, Paquette A, Shipley B, Heym M, Messier C, Gravel D. 2016. Shade 
 tolerance and the functional trait: demography relationship in temperate
  and boreal forests. Functional Ecology 31:821-830.
}
\keyword{datasets}
