% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{diamgr}
\alias{diamgr}
\title{Diameter growth of Norway spruce (Picea abies) trees.}
\format{
The data frame contains the following columns:
\describe{
\item{site}{site}	
\item{location}{location}
\item{tree}{Tree number}											
\item{age}{Total age, in yrs.}
\item{htot}{Total height, in m.}
\item{dbh}{Diameter at breast height, in cm.}
\item{volume}{Total volume, in m\eqn{^{3}}{^3}.}
\item{bha}{Breast-height age, in yrs.}
\item{tree.id}{Tree code, merging site, location and tree number.}
 }
}
\source{
Data were provided by Prof. Andrew Robinson, for his Statistical lectures at the
University of Idaho (USA), meanwhile Dr Christian Salas-Eljatib was a student there.
}
\usage{
data(diamgr)
}
\description{
von Guttenberg (1915) diameter growth data of Norway spruce trees in the Alps. 
The data contain measurements of 107 average-size trees from seven locations that encompassed five
 different sites from healthy, fully stocked stands growing in the Alps. These data are
more fully documented in Zeide (1993).
}
\examples{
data(diamgr)    
head(diamgr)
library(lattice)
xyplot(dbh ~ age | tree.id, type="b", data=diamgr) 
}
\references{
- von Guttenberg, A. R., 1915. Growth and yield of spruce in Hochgebirge.
   Franz Deuticke, Vienna (in German).
- Zeide, B., 1993. Analysis of growth equations. Forest Science 39 (3), 549-616. \doi{10.1093/forestscience/39.3.594}
}
\keyword{datasets}
