% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findColumn.byname.r
\name{findColumn.byname}
\alias{findColumn.byname}
\title{Finds the position of a specific variable.}
\usage{
findColumn.byname(data = data, col.name = col.name)
}
\arguments{
\item{data}{is a dataframe}

\item{col.name}{is a string specifying the name of the variable}
}
\value{
This function returns the number of a specific column-name.
}
\description{
Sometimes in data manipulation we face the task of locating the position
of a specific variable within a dataframe.  The function finds the position
 in 
which a column name is within an object.
}
\details{
Although the function finds the position of a specific variable, 
can also 
be used for more than one variable.
}
\note{
It can be used for a vector of specified column-names as well.
}
\examples{

df <- data.frame(varX=1:5, varY=letters[1:5], varZ=rep("a",5), 
varK=rep("b",5))
df
#using the function
findColumn.byname(df, c("varY","varZ"))
findColumn.byname(df, "varK")
#Creating an example vector
vector <- letters
vector
findColumn.byname(vector, c("h","z"))
}
\references{
Salas-Eljatib, C. 2021. Análisis de datos con el programa estadístico R:
 una introducción
 aplicada. Ediciones Universidad Mayor, Santiago, Chile. 170 p. 
 \url{https://eljatib.com/rlibro}
}
\author{
Christian Salas-Eljatib
}
